local open = io.open

local function read_file(path)
    local file = open(path, "rb") -- r read mode and b binary mode
    if not file then return nil end
    local content = file:read "*a" -- *a or *all reads the whole file
    file:close()
    return content
end

local function apply_stats(fileContent)
	if string.find(fileContent, "goalkeeper") ~= nil then
		local gk_stats = {"GK_Diving", "GK_Handling", "GK_Kicking", "GK_Reflexes", "GK_Positioning", "GK_Positioning" }
		for i = 1, 6 do
			_,val = string.match(fileContent, '(attnum' .. i .. '">)(%d+)')
            getAddressList().getMemoryRecordByDescription(gk_stats[i]).Value = val
		end
    end
	
	local stats = {"acceleration", "sprintspeed", "positioning", "finishing", "longshot", "penalties", "shotpower", "volleys", "crossing", "curve", "fkacc", "longpass", "shortpass", "vision", "agility", "balance", "ballcontrol", "dribbling", "reactions", "headingacc", "tactaware", "marking", "standingtackle", "slidetackle", "aggression", "jumping", "stamina", "strength", "composure"}
	local table_stats = {"Acceleration?", "Sprint Speed?", "Positioning?", "Finishing?", "Long Shots?", "Penalties?", "Shot Power?", "Volleys?", "Crossing?", "Curve?", "Free Kick Accuracy?", "Long Passing?", "Short Passing?", "Vision?", "Agility?", "Balance?", "Ball Control?", "Dribbling?", "Reactions?", "Heading Accuracy?", "Interceptions?", "Marking?", "Standing Tackle?", "Sliding Tackle?", "Aggression?", "Jumping?", "Stamina?", "Strength?", "Composure?"}
	for i = 1, #stats do
		_,val = string.match(fileContent, '('.. stats[i] ..'">)(%d+)')
		getAddressList().getMemoryRecordByDescription(table_stats[i]).Value = val
	end
    print("Done!")
end

apply_stats(read_file("futwiz.html"))